/* UPDATABLE VIEWS: Simple views are automatically updatable: the system will allow INSERT, UPDATE and DELETE statements to be used on the view
   in the same way as on a regular table. A view is automatically updatable if it satisfies all of the following conditions:
   The view must have exactly one entry in its FROM list, which must be a table or another updatable view.
   The view definition must not contain WITH, DISTINCT, GROUP BY, HAVING, LIMIT, or OFFSET clauses at the top level.
   The view definition must not contain set operations (UNION, INTERSECT or EXCEPT) at the top level.
   All columns in the view's select list must be simple references to columns of the underlying relation. They cannot be expressions,
   literals or functions. System columns cannot be referenced, either.
   No column of the underlying relation can appear more than once in the view's select list.
   The view must not have the security_barrier property.
   If the view is automatically updatable the system will convert any INSERT, UPDATE or DELETE statement on the view into the corresponding
   statement on the underlying base relation.

   ANMERKUNG:
   - Ab PostgreSQL 9.4 können update-bare und read-only columns gemischt werden.
   - Vorher geht also nur ein 1:1 Spaltenmapping
   - Es geht also NICHT sowas 'E' AS code oder NULL AS DokNummer
*/

-- Dummy / Leerfunktion zur Viewerstellung.
CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_stkb__offen__calc_viewwrapper(
    IN _auftg auftg,
    IN _ak_verfueg numeric
    ) 
    RETURNS numeric(12,4) 
    AS $$
    BEGIN
        
        -- TWaWi.auftg__ag_stkb__offen__calc is not defined at this point,
        -- hence this must be a plpgsql function
        RETURN TWaWi.auftg__ag_stkb__offen__calc( _auftg, _ak_verfueg, null );
        
    END $$ LANGUAGE plpgsql STABLE;


--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Auftrag__recreate() RETURNS VOID AS $$
  BEGIN
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS Twawi.Auftg_posext;
        DROP VIEW IF EXISTS TWawi.Auftg_Pos;
    --      
    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    CREATE OR REPLACE VIEW TWawi.Auftg_Pos AS
      SELECT
      -- Identifikatoren
        dbrid              AS dbrid                   ,--
        ag_id              AS p_id                    ,-- ID der Pos.
        ag_dokunr          AS p_dokunr                ,-- Referenz auf das zug. Dokument
        ag_astat           AS p_code                  ,-- Code / Klassifikation / Belegtyp
        ag_nr              AS p_nummer                ,-- Belegnummer
        ag_pos             AS p_pos                   ,-- Positionsnummer
        ag_hpos            AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --                 AS p_table                 ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        ag_aknr            AS p_aknr                  ,-- Artikelnummer
        ag_aknr_idx        AS p_aknr_idx              ,-- Artikelindex
        ag_akbz            AS p_akbez                 ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        ag_aknr_referenz   AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        ag_stk             AS p_menge                 ,-- Menge in Positions-ME
        ag_mcv             AS p_me                    ,-- artmgc.m_id der Positions-ME
        ag_vkp_mce         AS p_pme                   ,-- artmgc.m_id Mengeneinheit - Preis
        --                 AS p_los                   ,-- Losgröße für Artikel
        ag_stk_uf1         AS p_menge_gme             ,-- Menge in GME
        ag_stkb            AS p_mengeb_gme            ,-- Menge bestellt in GME
        ag_stkl            AS p_mengel_gme            ,-- Menge geliefert in GME
        ag_stkf            AS p_mengef_gme            ,-- Menge fakturiert in GME
        --                 AS p_mengeo                ,-- Offene Menge
        --                 AS p_mengeo_gme            ,-- Offene Menge in GME
        ag_nident          AS p_norm                  ,-- Artikelnorm
        ag_ks              AS p_ks                    ,-- Zugeordnete Kostenstelle
        --                 AS p_gme                   ,-- artmgc.m_id der Grundmengeneinheit
        --                 AS p_mec                   ,-- ME-Code der Positions-ME
        --                 AS p_gmec                  ,-- ME-Code der Grund-ME
        --                 AS p_meuf                  ,-- Umrechnungsfaktor von Pos.ME zu GME
      -- Preisdaten
        ag_preis           AS p_preis                 ,-- Preis pro ME (enthält Preiseinheit)
        ag_preiseinheit    AS p_preiseinheit          ,-- Menge auf die sich p_preis bezieht
        ag_prkl            AS p_preisklasse           ,
        ag_vkp             AS p_preis_me              ,-- Preis pro ME
        ag_vkp_basis_w     AS p_preis_gwaer           ,-- Preis pro ME in Grundwährung
        ag_vkp_uf1         AS p_preis_gme             ,-- Preis pro GME
        ag_vkp_uf1_basis_w AS p_preis_gme_gwaer       ,-- Preis pro GME in Grundwährung
        ag_kukl            AS p_kundenklasse          ,
        ag_waer            AS p_waer                  ,-- Pos. Währungseinheit
        ag_kurs            AS p_kurs                  ,-- Pos. Kurs zur Basiswährung
        ag_steucode        AS p_scode                 ,-- Steuercode
        ag_ustpr           AS p_sproz                 ,-- Steuerprozentsatz
        ag_arab            AS p_rabatt                ,-- Rabattsatz (0...100)
        ag_canRabatt       AS p_CanRabatt             ,-- Kennzeichen Rabattfähig
      -- Positionswerte
        ag_ep_netto        AS p_wert_ep_netto         ,-- Positionswert ohne Abzuschläge
        ag_netto           AS p_wert_netto            ,-- Positionswert inkl. AbZuschläge, exkl. Steuern
        ag_brutto          AS p_wert_brutto           ,-- Positionswert inkl. AbZuschläge, inkl. Steuern
        ag_netto_basis_w   AS p_wert_netto_gwaer      ,-- Positionswert inkl. AbZuschläge, exkl. Steuern, in Grundwährung  
        ag_brutto_basis_w  AS p_wert_brutto_gwaer     ,-- Positionswert inkl. AbZuschläge, inkl. Steuern, in Basiswährung        

      -- Adressdaten
        ag_lkn             AS p_adkrz                 ,-- Adresskürzel (Kunde o. Lieferant)
        ag_krzl            AS p_adkrzl                ,-- Adresskürzel Lieferadresse
        ag_krzf            AS p_adkrzf                ,-- Adresskürzel Rechnungsadresse
        ag_dispokrzl       AS p_apext                 ,-- Kürzel Ansprechpartner extern
        ag_dispo           AS p_apextname             ,-- Voller Name Ansprechpartner extern
        ag_kontakt         AS p_apint                 ,-- Kürzel Ansprechpartner intern
        --                 AS p_apintname             ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        ag_bdat            AS p_datum_eingang         ,-- Eingangsdatum
        ag_datum           AS p_datum_erfasst         ,-- Erfassdatum
        ag_kdatum          AS p_datum_soll            ,-- Wunschdatum
        ag_ldatum          AS p_datum_ist             ,-- Bestätigtes Datum
        --                 AS p_datum_istsoll         ,-- COALESCE(Bestätigtes, Wunschdatum )
        ag_stornodat       AS p_datum_storniert       ,-- Datum an dem die Pos. Storniert wurde
        --                 AS p_definitiv             ,-- Kennzeichen Pos. Definitiv
        ag_done            AS p_done                  ,-- Kennzeichen Pos. Erledigt
        ag_storno          AS p_storniert             ,-- Kennzeichen Pos. Storniert
        --                 AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                 AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        NOT ag_nstatistik  AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
        ag_stat            AS p_stat                  ,-- interner Status
        ag_bstat           AS p_status                ,-- Allg. Status1
        ag_bstat1          AS p_status1               ,-- Allg. Status2
        ag_bstat2          AS p_status2               ,-- Allg. Status3
      -- Referenzen / Struktur
        ag_rahmen_ag_id    AS p_rahmen_id             ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        --                 AS p_vorgaenger_table      ,--
        --                 AS p_vorgaenger_id         ,--
        ag_bda             AS p_refnummer             ,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)
        ag_bdapos          AS p_refpos                ,-- Referenz auf ext.Position (Z.Bsp. Bestellpos. - Kunde)
        ag_an_nr           AS p_an_nr                 ,-- Projektnummer
        ag_vtp_id          AS p_vtp_id                ,-- ID der zugehörigen Vertragsposition
        ag_ownabk          AS p_ab_ix                 ,-- Zugehörige ABK
        ag_q_nr            AS p_q_nr                  ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        ag_konto           AS p_Konto                 ,--
        ag_txt             AS p_txt_ext               ,--
        ag_txt_rtf         AS p_txt_ext_rtf           ,--
        ag_postxt          AS p_txt_int               ,--
        ag_postxt_rtf      AS p_txt_int_rtf            --
      FROM auftg;
    --
    
    -- Erweiterter Anzeige-View => Nur lesbar. Felder aus Basis-View und angejointen Tabellen.
    CREATE OR REPLACE VIEW TWawi.Auftg_PosExt AS
      SELECT
      -- Identifikatoren
        pos.dbrid          AS dbrid                      ,--
        p_id                                             ,-- ID der Pos.
        p_dokunr::VARCHAR  AS p_dokunr                   ,-- Referenz auf das zug. Dokument
        p_code                                           ,-- Code / Klassifikation / Belegtyp
        p_nummer                                         ,-- Belegnummer
        p_pos                                            ,-- Positionsnummer
        p_parent                                         ,-- Übergeordnete Position (Strukt. Belege)
        'auftg'::VARCHAR   AS p_table                    ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        p_aknr                                           ,-- Artikelnummer
        COALESCE(p_aknr_idx, ak_idx) AS p_aknr_idx       ,-- Artikelindex
        COALESCE(p_akbez, ak_bez) AS p_akbez             ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        p_aknr_referenz                                  ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        p_menge                                          ,-- Menge in Positions-ME
        p_me                                             ,-- artmgc.m_id der Positions-ME
        ak_los             AS p_los                      ,-- Losgröße für Artikel
        p_menge_gme                                      ,-- Menge in GME
        p_mengeb_gme                                     ,-- Menge bestellt in GME
        p_mengel_gme                                     ,-- Menge geliefert in GME
        p_mengef_gme                                     ,-- Menge fakturiert in GME
        tartikel.me__menge_uf1__in__menge(p_me, stkbOffen.stk) AS p_mengeo    ,-- Noch zu bestellende Menge
        stkbOffen.stk      AS p_mengeo_gme               ,-- Noch zu bestellende Menge in GME
        p_norm                                           ,-- Artikelnorm
        p_ks                                             ,-- Zugeordnete Kostenstelle
      -- Mengeneinheitsdaten
        MEData.p_gme                                     ,-- Artmgc.m_id der Grundmengeneinheit
        MEData.p_mec                                     ,-- ME-Code der Positions-ME
        MEData.p_gmec                                    ,-- ME-Code der Grund-ME
        MEData.p_meuf                                    ,-- Umrechnungsfaktor Positions-ME zu Grund-ME
        MEData.p_meiso                                   ,-- ISO-Code der Positions-ME
        MEData.p_gmeiso                                  ,-- ISO-Code der Grund-ME
      -- Preisdaten
        p_preis                                          ,-- Preis pro ME (enthält Preiseinheit)
        p_preiseinheit                                   ,-- Menge auf die sich p_preis bezieht
        p_preis_me                                       ,-- Preis pro ME
        p_preis_gwaer                                    ,-- Preis pro ME in Grundwährung
        p_preis_gme                                      ,-- Preis pro GME
        p_preis_gme_gwaer                                ,-- Preis pro GME in Grundwährung
        p_waer                                           ,-- Pos. Währungseinheit
        p_kurs                                           ,-- Pos. Kurs zur Basiswährung
        p_scode                                          ,-- Steuercode
        p_sproz                                          ,-- Steuerprozentsatz
        p_rabatt                                         ,-- Rabattsatz (0...100)
        p_canRabatt                                      ,-- Kennzeichen Rabattfähig
        steu_txt           AS p_sbez                     ,-- Steuerbezeichnung
      -- Positionswerte
        p_wert_ep_netto                                  ,-- Positionswert ohne Abzuschläge
        p_wert_netto                                     ,-- Positionswert inkl. AbZuschläge, exkl. Steuern
        p_wert_brutto                                    ,-- Positionswert inkl. AbZuschläge, inkl. Steuern
        p_wert_netto_gwaer                               ,-- Positionswert inkl. AbZuschläge, exkl. Steuern, in Grundwährung  
        p_wert_brutto_gwaer                              ,-- Positionswert inkl. AbZuschläge, inkl. Steuern, in Basiswährung
      -- Adressdaten
        p_adkrz                                          ,-- Adresskürzel (Kunde o. Lieferant)
        p_adkrzl                                         ,-- Adresskürzel Lieferadresse
        p_adkrzf                                         ,-- Adresskürzel Rechnungsadresse
        p_apext                                          ,-- Kürzel Ansprechpartner extern
        p_apExtName                                      ,-- Voller Name Ansprechpartner extern
        p_apInt                                          ,-- Kürzel Ansprechpartner intern
        nameAufloesen(p_apInt) AS p_apintname            ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        p_datum_eingang                                  ,-- Eingangsdatum
        p_datum_erfasst                                  ,-- Erfassdatum
        p_datum_soll                                     ,-- Wunschdatum
        p_datum_ist                                      ,-- Bestätigtes Datum
        COALESCE(ag_aldatum, p_datum_ist, p_datum_soll) AS p_datum_istsoll,-- Eigentlicher Termin
        p_datum_storniert                                ,-- Datum an dem die Pos. Storniert wurde
        true               AS p_definitiv                ,-- Kennzeichen Pos. Definitiv
        p_done                                           ,-- Kennzeichen Pos. Erledigt
        p_storniert                                      ,-- Kennzeichen Pos. Storniert
        ag_nbedarf         AS p_IsBedarf                 ,-- Kennzeichen bedarfswirksame Position
        ak_fertigung       AS p_IsFertigung              ,-- Kennzeichen Fertigungsartikel (oder Fert.Position)
        p_IsUmsatz                                       ,-- Kennzeichen umsatzwirksame Position
        p_stat                                           ,-- interner Status
        p_status                                         ,-- Allg. Status1
        p_status1                                        ,-- Allg. Status2
        p_status2                                        ,-- Allg. Status3
      -- Referenzen / Struktur
        p_rahmen_id                                      ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        NULL::VARCHAR      AS p_vorgaenger_table         ,--
        NULL::INTEGER      AS p_vorgaenger_id            ,--
        p_refnummer                                      ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)
        p_refpos                                         ,-- Referenz auf ext.Position (Z.Bsp. Bestell-Pos. Kunde)
        p_an_nr                                          ,-- Projektnummer
        p_vtp_id                                         ,-- ID der zugehörigen Vertragsposition
        p_ab_ix                                          ,-- Zugehörige ABK
        p_q_nr                                           ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        p_Konto                                          ,-- Kontierung
        p_txt_ext                                        ,-- Positionstext extern
        p_txt_ext_rtf                                    ,--
        p_txt_int                                        ,-- Positionstext intern
        p_txt_int_rtf                                     --
      FROM TWawi.Auftg_Pos AS pos
        JOIN auftg             ON ag_id      = p_id 
        JOIN art               ON ak_nr      = p_aknr
        LEFT JOIN steutxt      ON steu_z     = p_scode 
        LEFT JOIN auftgmatinfo ON agmi_ag_id = p_id
        -- Noch zu bestellende Menge der Position berechnen
        , LATERAL( SELECT TWaWi.auftg__ag_stkb__offen__calc_viewwrapper(auftg, ak_Verfueg) AS stk
                 ) AS stkbOffen
        -- Informationen zur Mengenumrechnung mit aufnehmen
        , LATERAL( SELECT m2.m_id     AS p_gme,
                          m1.m_mgcode AS p_mec,
                          m2.m_mgcode AS p_gmec,
                          m1.m_uf     AS p_meuf,
                          lang_artmgc_id_iso(p_me)    AS p_meiso,
                          lang_artmgc_id_iso(m2.m_id) AS p_gmeiso
                   FROM art JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = p_me)
                            JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
                   WHERE m1.m_ak_nr = pos.p_aknr
                 ) AS medata
      ;
    --
    
    
    
    
  END $$ LANGUAGE plpgsql;
--

--SELECT TSystem.views__Wawi_Auftrag__recreate();
